# Dice Emporium — Project

Project: Small website about dice (class assignment)

Pages included:
- index.html — Home / Hero / Overview
- history.html — "History of Dice"
- types.html — "Different Types of Dice"
- roller.html — "Interactive Dice Roller"
- contact.html — Contact form & location

Features:
- External stylesheet at `css/styles.css`
- Responsive (mobile <=640px, desktop 641+)
- CSS Grid used for key layouts
- Subtle CSS transitions for links and buttons
- Contact form with required fields (First Name, Last Name, Email) and optional message
- Google Maps iframe embedded on contact page
- Phone number and address on all pages
- Social links and footer with copyright
- Favicon and simple logo in `assets/`

How to validate:
- HTML: https://validator.w3.org/
- CSS: https://jigsaw.w3.org/css-validator/
- Accessibility: https://wave.webaim.org/

Accessibility & Validation notes:
- Add a keyboard "Skip to main content" link at the top of each page.
- All images include `alt` text and form inputs use proper `label` elements.
- Required fields use the HTML `required` attribute and `aria-required="true"` for clarity.
- Use the WAVE tool to get page accessibility suggestions (color contrast, form labels, ARIA usage).
- Run HTML & CSS validators and fix any syntax or structural warnings before submission.

Testing locally:
- Open `index.html` in a browser and resize the window to see mobile and desktop layouts (<=640px and 641+).
- Use browser devtools Lighthouse or WAVE extension to identify accessibility issues.

"Next steps" — open files in browser and check responsiveness and validation.